local curScreen = Var "LoadingScreen"
local jacketSize = 140
local jacketPos = -_screen.cx + ((jacketSize / 2) + 2)

return Def.ActorFrame{
	--[[
	Def.Quad{
		OnCommand=function(self)
			self:horizalign(left):vertalign(bottom):xy(-_screen.cx-30,24):zoomto(_screen.w,100):diffuse(LocalBlueColor(0.6)):skewx(0.1)
		end
	},
	Def.Quad{
		OnCommand=function(self)
			self:horizalign(left):vertalign(bottom):xy(-_screen.cx-30,20):zoomto(_screen.w,60):diffuse(LocalBlueColor(1)):skewx(0.1)
		end
	},
	Def.Quad{
		OnCommand=function(self)
			self:zoomto(_screen.cx*1.5,50):xy(20,-12):diffuse(LocalBlueColor(0)):skewx(0.1)
		end
	},
	--]]
	LoadActor("demoback") .. {
		InitCommand=function(self)
			self:vertalign(bottom):y(20)
		end
	},
	Def.BitmapText {
		Font = "Common Normal",
		InitCommand=cmd(zoom,0.4;y,-12;maxwidth,276 / 0.4;maxheight,40 / 0.4;wrapwidthpixels,276 / 0.4;strokecolor,Color.Black),
		CurrentSongChangedMessageCommand=cmd(playcommand,"Refresh"),
		RefreshCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			
			local songText = "???"
			
			if song then
				songText = song:FormattedSongTitleAndArtist()
			end
			
			self:settext(songText)
			--self:playcommand( "On" )
		end
	},
	Def.BitmapText {
		Font = "Common Normal",
		InitCommand=function(self)
			self:zoom(0.3):horizalign(left):strokecolor(Color.Black):xy(-_screen.cx+(jacketSize+10), -58)
		end,
		CurrentSongChangedMessageCommand=cmd(playcommand,"Refresh"),
		RefreshCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			if not song then return end
			
			--local pmTxt = song:GetParamaniaTxt()
			local pmIni = song:GetParamaniaIni()
			--SM(pmIni)
			
			-- Check if Demonstration's playing a Freestyle difficulty chart (by ParaMania difficulty standards), or a non-PARA mode chart.
			local lowestDifficulty = GAMESTATE:GetEasiestStepsDifficulty()
			local hardestDifficulty = GAMESTATE:GetHardestStepsDifficulty()
			if GAMESTATE:GetCurrentGame():GetName() ~= "para" or Enum.Compare(Difficulty, lowestDifficulty, Difficulty[2]) > 0 then
				local auText = GAMESTATE:GetCurrentGame():GetName() == "para" and THEME:GetString("Misc", "AuthorFSP") or THEME:GetString("Misc", "AuthorNP")
				local pmAdd = (pmIni.Metadata and #pmIni.Metadata > 0 and pmIni.Metadata.FreestyleVJ and pmIni.Metadata.FreestyleVJ ~= "") and "\nVJ: " .. pmIni.Metadata.FreestyleVJ or ""
				self:settext(auText .. ": " .. GAMESTATE:GetCurrentSteps(GAMESTATE:GetMasterPlayerNumber()):Author() .. pmAdd .. "\n♫ - " .. song:GetCredit())
			else
				local pmAdd
				local vCred = song:GetOrigin()
				if #pmIni.Metadata > 0 then 
					local danC = (lowestDifficulty == Difficulty[2] and pmIni.Metadata.AltDancers and pmIni.Metadata.AltDancers ~= "") and pmIni.Metadata.AltDancers or pmIni.Metadata.Dancers
					local cHo = (lowestDifficulty == Difficulty[2] and pmIni.Metadata.AltChoreo and pmIni.Metadata.AltChoreo ~= "") and pmIni.Metadata.AltChoreo or pmIni.Metadata.Choreo
					-- oops
					vCred = (lowestDifficulty == Difficulty[2] and pmIni.Metadata.AltVidSource and pmIni.Metadata.AltVidSource ~= "") and pmIni.Metadata.AltVidSource or song:GetOrigin()
					pmAdd = THEME:GetString("Misc", "MdDancer") .. ": " .. danC .. " | " .. THEME:GetString("Misc", "MdChoreo") .. ": " .. cHo .. "\n"
				else
					pmAdd = ""
				end
				
				self:settext(pmAdd .. "V - " .. vCred .. "\n♫ - " .. song:GetCredit())
			end
			--self:playcommand( "On" )
		end
	},
	-- Jacket frame.
	LoadActor("jacketFrame") .. {
		OnCommand=cmd(x,jacketPos;y,-jacketSize/3-9;)
	},
	
	-- Jacket itself.
	Def.Sprite {
		OnCommand=function(self)
			local song = GAMESTATE:GetCurrentSong()
			
			if song then
				self:LoadBanner(song:GetJacketOrSubstitutePath())
			else
				self:LoadBanner(THEME:GetPathG("Common","fallback jacket"))
			end
			self:scaletoclipped(jacketSize,jacketSize):x(jacketPos):y(-jacketSize/3-9)
		end
	},
}
